---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-Juliaプロンプト（julia>）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **履歴ファイルパス**: `~/.julia/logs/repl_history.jl` の正確なパス確認が必要
  2. **StylingPassesの構文ハイライト詳細**: 実装の詳細確認が推奨
  3. **ast_transforms の具体的な使用例**: パッケージ自動インストールフック等の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/REPL/src/REPL.jl` 118-132行 - REPLBackend構造体
- E-02: `stdlib/REPL/src/REPL.jl` 677-701行 - run_repl()関数
- E-03: `stdlib/REPL/src/REPL.jl` 764-776行 - LineEditREPL構造体
- E-04: `stdlib/REPL/src/REPL.jl` 1254-1399行 - setup_interface()関数
- E-05: `stdlib/REPL/src/REPL.jl` 113行 - JULIA_PROMPT定数
- E-06: `stdlib/REPL/src/REPL.jl` 157-173行 - softscope()関数
- E-07: `stdlib/REPL/src/REPL.jl` 448行〜 - repl_backend_loop()関数
- E-08: `stdlib/REPL/src/REPL.jl` 1200-1228行 - mode_keymap()
- E-09: `stdlib/REPL/src/REPL.jl` 1236-1243行 - contextual_prompt()
- E-10: `docs/code-to-docs/画面遷移図.md` - 画面遷移定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3種類のREPL実装が存在する | E-01, E-03 | ○ |
| C-02 | REPLバックエンドとフロントエンドがChannelで通信する | E-01 | ○ |
| C-03 | run_repl()がフロントエンドとバックエンドを起動する | E-02 | ○ |
| C-04 | softscope()によりREPL固有のスコープ規則が適用される | E-06 | ○ |
| C-05 | プロンプト文字列が「julia> 」である | E-05 | ○ |
| C-06 | アクティブモジュールがMain以外でプレフィックスが表示される | E-09 | ○ |
| C-07 | ?キーでヘルプモードに遷移する | E-04, E-10 | ○ |
| C-08 | ;キーでシェルモードに遷移する | E-04, E-10 | ○ |
| C-09 | ]キーでPkgモードに遷移する | E-04, E-10 | ○ |
| C-10 | Ctrl+Rで履歴検索モードに遷移する | E-10 | ○ |
| C-11 | Backspace（行頭）またはCtrl+Cで他モードからJuliaプロンプトに戻る | E-08, E-10 | ○ |
| C-12 | セミコロンで終わる式は結果を表示しない | E-07 | ○ |
| C-13 | setup_interface()で各モードのPromptが設定される | E-04 | ○ |
| C-14 | REPLCompletionProviderがTab補完を提供する | E-04 (1287行) | ○ |
| C-15 | SyntaxHighlightPassとEnclosingParenHighlightPassが設定される | E-04 (1298-1301行) | ○ |
| C-16 | repl_backend_loop()がChannelからASTを受信してevalする | E-07 | ○ |
| C-17 | ast_transformsで評価前変換が可能 | E-01 (126行) | ○ |
| C-18 | Ctrl+Dで REPL終了 | E-10 | ○ |
| C-19 | 15種類の関連機能が存在する | E-11 | ○ |
| C-20 | 履歴は~/.julia/logs/repl_history.jlに保存される | **根拠なし** | △ |
| C-21 | InterruptExceptionでCtrl+Cによる中断が処理される | E-08 | ○ |
| C-22 | on_enterコールバックで入力完了判定が行われる | E-04 (1297行) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-20: 履歴ファイルの正確なパスは `find_hist_file()` 関数の実装を確認する必要がある。一般的には `~/.julia/logs/repl_history.jl` だが、環境変数や設定で変更される可能性がある。
  - 候補：`stdlib/REPL/src/REPL.jl` 内の find_hist_file() / `stdlib/REPL/src/History/histfile.jl`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロンプト表示とモード遷移は確立されたパターン
- 1: 中リスク - softscope()のスコープ変換の正確な動作確認が推奨
- 0: 低リスク - Channel通信によるフロントエンド/バックエンド分離は明確

## 6) レビュアーチェックリスト（最小）
- [ ] 3種類のREPL実装（LineEditREPL, BasicREPL, StreamREPL）の記述が正しいか確認
- [ ] モード遷移キー（?, ;, ], Ctrl+R）の記述が遷移図と一致しているか確認
- [ ] REPLバックエンドの評価ループの記述が正しいか確認
- [ ] contextual_prompt()によるモジュールプレフィックスの記述が正しいか確認
